/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
package DataClasses;
/**
 * @author student
 *
 * This class is being used for holding the information regarding stocks.
 * 
 */
public class Stock_Data {

	private String stockCode;
	private String companyName;
	private String weekHigh;
	private String weekLow;
	private String baseValue;
	private String earningsPerShare;
	private String dividendsPerShare;
	private String quantity;
	private float price;
	private float peRatio;
	private float divYield;
	private boolean visible;
	
	/**
	 * This is the constructor for Stock_Data.java
	 */
	public Stock_Data() {
	}

	/**
	 * This is the constructor for Stock_Data.java
	 */
	public Stock_Data(
		String code,
		String name,
		String high,
		String low,
		String bv,
		String eps,
		String dps) {
		this.stockCode = code;
		this.companyName = name;
		this.weekHigh = high;
		this.weekLow = low;
		this.baseValue = bv;
		this.earningsPerShare = eps;
		this.dividendsPerShare = dps;
		this.visible = false;
	}

	/**
	 * This method is being used for setting the stock code field.
	 * @param code The stock code
	 * @return void
	 */
	public void setStockCode(String code) {
		this.stockCode = code;
	}
	/**
	 * This method is being used for getting the stock code field.
	 * @return String The stock code.
	 */
	public String getStockCode() {
		return this.stockCode;
	}

	/**
	 * This method is being used for setting the stock issuing company name.
	 * @param name The company name
	 * @return void
	 */
	public void setCompanyName(String name) {
		this.companyName = name;
	}
	
	/**
	 * This method is being used for getting the company name field.
	 * @return String The company name.
	 */
	public String getCompanyName() {
		return this.companyName;
	}

	/**
	 * This method is being used for setting the 52-week high value of the stock.
	 * @param high The 52-week high value
	 * @return void
	 */
	public void setWeekHigh(String high) {
		this.weekHigh = high;
	}
	
	/**
	 * This method is being used for getting the 52-week high value of the stock.
	 * @return String The 52-week high value
	 */
	public String getWeekHigh() {
		return this.weekHigh;
	}
	
	/**
	 * Method: setWeekLow
	 * This method is being used for setting the 52-week low value of the stock.
	 * @param low The 52-week low value 
	 * @return void
	 */
	public void setWeekLow(String low) {
		this.weekLow = low;
	}
	/**
	 * This method is being used for getting the 52-week low value of the stock.
	 * @return String The 52-week low value
	 */
	public String getWeekLow() {
		return this.weekLow;
	}
	
	/**
	 * This method is being used for setting the earnings per share value
	 * of the stock.
	 * @param eps The earnings per share
	 * @return void
	 */
	public void setEarningsPerShare(String eps) {
		this.earningsPerShare = eps;
	}
	/**
	 * This method is being used for getting the earnings per share value
	 * of the stock.
	 * @return String The earnings per share value of the stock.
	 */
	public String getEarningsPerShare() {
		return this.earningsPerShare;
	}
	/**
	 * This method is being used for seeting the dividends per share value
	 * of the stock.
	 * @param dps The dividends per share value
	 * @return void
	 */
	public void setDividendsPerShare(String dps) {
		this.dividendsPerShare = dps;
	}
	
	/**
	 * This method is being used for getting the dividends per share value
	 * of the stock.
	 * @return String
	 */
	public String getDividendsPerShare() {
		return this.dividendsPerShare;
	}
	/**
	 * This method is being used for setting the base value of the stock.
	 * @param bv The base value around which share prices are generated.
	 * @return void
	 */
	public void setBaseValue(String bv) {
		this.baseValue = bv;
	}
	/**
	 * This method is being used for getting the base value of the stock.
	 * @return String The base value around which the share prices are generated
	 */
	public String getBaseValue() {
		return this.baseValue;
	}

	/**
	 * Method: setQuantity
	 * This method is being used for setting the quantity
	 * @param q void
	 */
	public void setQuantity(String q) {
		this.quantity = q;
	}
	public String getQuantity() {
		return this.quantity;
	}
	/**
	 * This method is being used for getting the service code for the stock
	 * trading platform.
	 * @return String Service code that is to be used in TMS.
	 */
	public String getServiceCode() {
		return "StockServiceCode";
	}
	/**
	 * This method is being used for getting the service request field.
	 * @return String Service request that is to be used in TMS.
	 */
	public String getServiceRequest() {
		return "Request";
	}
	/**
	 * This method is being used for getting the srvice response field.
	 * @return String Service response that is to be used in TMS.
	 */
	public String getServiceResponse() {
		return "Response";
	}
	/**
	 * This method is being used for getting the current share price.
	 * @return float The current share price.
	 */
	public float getPrice() {
		return this.price;
	}
	/**
	 * This method is being used for setting the current share price.
	 * @param p The current share price.
	 * @return void
	 */
	public void setPrice(float p) {
		this.price = p;
	}

	/**
	 * Method: getVisible
	 * This method is being used for getting the visible field.
	 * @return boolean Whether the stock price is currently visible on the
	 * graph.
	 */
	public boolean getVisible() {
		return this.visible;
	}
	/**
	 * This method is being used for setting the visible field.
	 * @param b Whether the stock is visible on the graph.
	 * @return void
	 */
	public void setVisible(boolean b) {
		this.visible = b;
	}
	/**
	 * This method is being used for getting the pe ration of the stock.
	 * @return float The PE ratio.
	 */
	public float getPeRatio() {
		return this.peRatio;
	}
	
	/**
	 * This method is being used for setting the pe ratio of the stock.
	 * @param p The PE ratio.
	 * @return void
	 */
	public void setPeRatio(float p) {
		this.peRatio = p;
	}
	/**
	 * This method is being used for getting the dividend yield of the stock.
	 * @return float The dividend yield.
	 */
	public float getDivYield() {
		return this.divYield;
	}
	/**
	 * This method is being used for setting the dividend yield of the stock.
	 * @param d The dividend yield.
	 * @return void
	 */
	public void setDivYield(float d) {
		this.divYield = d;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return this.stockCode + "," + this.companyName;
	}
}
